﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SoldStationPeripherals.ascx.vb" Inherits="Web.SoldStationPeripherals" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/private/stations/base/Sections/ControlMode.ascx" TagName="cu_controlmode" TagPrefix="uc" %>

<div class="mode-panel">
    <div class="holder">
        <uc:cu_controlmode ID="cu_controlmode" runat="server"  Visible="false" />
    </div>
</div>
<asp:UpdatePanel runat="server" Id="UpdatePanelSliderPerifericos" UpdateMode="Conditional">
<ContentTemplate>  
    
<div class="parameters-block">

    <!-- Estación no soporta perifericos-->
    <asp:Panel ID="panelSinPeri" runat="server" Visible="true">
	<div class="text-container">
		<div class="text-holder">
			<h2><span><%= CurrentContext.Translator.Translate("STATION_NOTPERIPHERAL")%></span></h2>
		</div>
    </div>
    </asp:Panel>

    <!-- Estación no tiene periféricos conectados-->
    <asp:Panel ID="panelNoPeri" runat="server" Visible="true">
	<div class="text-container">
		<div class="text-holder">
			<h2><span><%= CurrentContext.Translator.Translate("MSG_NOTPERIPHERAL")%></span></h2>
		</div>
    </div>
    </asp:Panel>

    <!-- Estación con periféricos conectados-->
    <asp:Panel ID="panelActivo" runat="server" Visible="true">
    <div  class="peripheral-block">
        <ul class="peripheral-list jcf-scrollable" id="DivCamps" runat="server">
            <li>
                <asp:LinkButton Width="85px" runat="server" CssClass="btn" style="visibility:hidden;"></asp:LinkButton>
                <asp:Label ID="LblNumPort_1" Text="1" CssClass="peripheral-port first" runat="server"></asp:Label>
                <asp:Label ID="LblNumPort_2" Text="2" CssClass="peripheral-port" runat="server"></asp:Label>
                <asp:Label ID="LblNumPort_3" Text="3" CssClass="peripheral-port" runat="server"></asp:Label>
                <asp:Label ID="LblNumPort_4" Text="4" CssClass="peripheral-port" runat="server"></asp:Label>
            </li>   
           <asp:Repeater ID="repeater_perifericos" runat="server">
                <ItemTemplate>
                    <li>
                        <asp:LinkButton ID="lnkperiferico" OnClick="btnPeripheral_Click"  Width="100px" Text='<%# Eval("Name")%>' runat="server" CssClass="btn" CommandArgument='<%# String.Concat(Eval("ID"), "#", Eval("Name"), "#" & Eval("Port"))%>' CommandName='<%# Eval("Type")%>'></asp:LinkButton>
                        <asp:CheckBox ID='Ckport0' runat="server" CommandName='<%# String.Concat(Eval("ID"), "#", Eval("Port"))%>' OnCheckedChanged="ckport_CheckedChanged" Checked="false" Enabled="true" CssClass="peripheral_radio port0" AutoPostBack="true"/>
                        <asp:CheckBox ID='Ckport1' runat="server" CommandName='<%# String.Concat(Eval("ID"), "#", Eval("Port"))%>' OnCheckedChanged="ckport_CheckedChanged" Checked="false" Enabled="true" CssClass="peripheral_radio port1"  AutoPostBack="true" />
                        <asp:CheckBox ID='Ckport2' runat="server" CommandName='<%# String.Concat(Eval("ID"), "#", Eval("Port"))%>' OnCheckedChanged="ckport_CheckedChanged" Checked="false" Enabled="true" CssClass="peripheral_radio port2"  AutoPostBack="true" />
                        <asp:CheckBox ID='Ckport3' runat="server" CommandName='<%# String.Concat(Eval("ID"), "#", Eval("Port"))%>' OnCheckedChanged="ckport_CheckedChanged" Checked="false" Enabled="true" CssClass="peripheral_radio port3"  AutoPostBack="true"/>
                    </li>
                </ItemTemplate>
            </asp:Repeater> 
        </ul>
    </div>

    </asp:Panel> 

    <!--Panel de de formulario de entrada de datos -->
    <asp:Panel ID="PanelEntradaDatos" runat="server" Style="display:none" CssClass="error-message">
    <div class="holder">
        <asp:Literal ID="identificador" Visible="false" runat="server"></asp:Literal>
        <asp:Literal ID="info_perifericoName" runat="server" ></asp:Literal>
        <br />
        <asp:Literal ID="info_perifericoType" runat="server"></asp:Literal>
        <br />
        <div style="text-align:center;">
            <div style="float:inherit; display: inline-block;">
                <asp:Literal ID="info_periferico_Function" runat="server" ></asp:Literal>
                <asp:DropDownList runat="server" ID="CbFunction" CssClass="combo"   style="margin:0 auto;display:block !important;" ></asp:DropDownList>
            </div>
                <div style="float:inherit;margin-left:10px; display: inline-block;" >
                <asp:Literal ID="info_periferico_activation" runat="server" ></asp:Literal>
                <asp:DropDownList runat="server" ID="CbActivation" CssClass="combo"  style="margin:0 auto;display:block !important;" ></asp:DropDownList>
            </div>
                <div style="float:inherit;margin-left:10px; display: inline-block;">
                <asp:Literal ID="info_periferico_time" runat="server" ></asp:Literal>
                <asp:DropDownList runat="server" ID="CbTime" CssClass="combo"  style="margin:0 auto;display:block !important; width:125px;" ></asp:DropDownList>
            </div>
        </div>
        <div  style="clear:both;content:"";> </div>
        <br />
        <asp:LinkButton ID="btnAceptar_PanelEntradaDatos" runat="server" CssClass="btn"  OnClick="btnAceptar_PanelEntradaDatos_Click"></asp:LinkButton>
        <asp:LinkButton ID="btnCancelar_PanelEntradaDatos" runat="server" CssClass="btn"  ></asp:LinkButton>
    </div>
    </asp:Panel>
</div>

<!-- controles ajax-->
<ajaxToolkit:ModalPopupExtender ID="MPE_PanelEntradaDatos" runat="server" TargetControlID="hdnPanelEntradaDatos" PopupControlID="PanelEntradaDatos" BackgroundCssClass="" DropShadow="false" PopupDragHandleControlID="" X="0"/>

<!-- controles ocultos-->
<asp:HiddenField ID="hdnPanelEntradaDatos" runat="server" />



</ContentTemplate>
</asp:UpdatePanel>


<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderSliderPerifericos" TargetControlID="UpdatePanelSliderPerifericos" BehaviorID="animation" runat="server">    
<Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen(); initRefreshFunctions2($('div.ajax-holder'));" />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<asp:UpdateProgress ID="UpdateProgressSliderPerifericos" runat="server" AssociatedUpdatePanelID="UpdatePanelSliderPerifericos" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" />
    </ProgressTemplate>
</asp:UpdateProgress> 
